<?php
/*
 *    Copyright (c) 2009 Bouncing Minds - Option 3 Ventures Limited
 *
 *    This file is part of the Regions plug-in for Flowplayer.
 *
 *    The Regions plug-in is free software: you can redistribute it
 *    and/or modify it under the terms of the GNU General Public License
 *    as published by the Free Software Foundation, either version 3 of
 *    the License, or (at your option) any later version.
 *
 *    The Regions plug-in is distributed in the hope that it will be
 *    useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with the plug-in.  If not, see <http://www.gnu.org/licenses/>.
 */

require_once LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH . '/plugins/bannerTypeHtml/vastInlineBannerTypeHtml/common.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
abstract class Plugins_BannerTypeHTML_vastInlineBannerTypeHtml_vastBase extends Plugins_BannerTypeHTML
{
    abstract function getBannerShortName();
    abstract function getZoneToLinkShortName();
    abstract function getHelpAdTypeDescription();
    private $requiredElement = array();

    /**
     * Return the media (content) type
     */
    function getContentType()
    {
        return 'html';
    }

    /**
     * return the storage type
     *
     */
    function getStorageType()
    {
        return 'html';
    }



    private $validationFailed = false;

    function buildForm(&$form, &$bannerRow)
    {
        if($form->isSubmitted()) {
            $form->addElement('html', 'video_form_error', VideoAdsHelper::getWarningMessage('Validation failed!'));
        }
    }
    /**
     * This method is executed BEFORE the core banners table is written to
     *
     * @param boolean $insert
     * @param integer $bannerid
     * @param array $aFields
     * @param array $aVariables
     * @return boolean
     */
    function preprocessForm($insert, $bannerid, &$aFields, &$aVariables)
    {
        combineVideoUrl( $aFields );
        $aVastVariables = array();
        $aVastVariables['banner_vast_element_id'] = $aFields['banner_vast_element_id'];
        $aVastVariables['vast_element_type'] = 'singlerow'; //$aFields['vast_element_type'];
        $aVastVariables['vast_video_id'] = $aFields['vast_video_id'];
        $aVastVariables['vast_video_duration'] = $aFields['vast_video_duration'];
        $aVastVariables['vast_video_delivery'] = $aFields['vast_video_delivery'];
        $aVastVariables['vast_video_type'] = $aFields['vast_video_type'];
        $aVastVariables['vast_video_bitrate'] = $aFields['vast_video_bitrate'];
        $aVastVariables['vast_video_height'] = $aFields['vast_video_height'];
        $aVastVariables['vast_video_width'] = $aFields['vast_video_width'];
        $aVastVariables['vast_video_outgoing_filename'] = $aFields['vast_video_outgoing_filename'];
        $aVastVariables['vast_video_clickthrough_url'] = $aFields['vast_video_clickthrough_url'];
        $aVastVariables['vast_overlay_height'] = $aFields['vast_overlay_height'];
        $aVastVariables['vast_overlay_width'] = $aFields['vast_overlay_width'];
        $aVastVariables['vast_overlay_text_title'] = $aFields['vast_overlay_text_title'];
        $aVastVariables['vast_overlay_text_description'] = $aFields['vast_overlay_text_description'];
        $aVastVariables['vast_overlay_text_call'] = $aFields['vast_overlay_text_call'];
        $aVastVariables['vast_overlay_format'] = $aFields['vast_overlay_format'];
        $aVastVariables['vast_overlay_action'] = $aFields['vast_overlay_action'];
        $aVastVariables['vast_companion_banner_id'] = $aFields['vast_companion_banner_id'];
        $aVastVariables['vast_creative_type'] = $aFields['vast_creative_type'];
        $aVastVariables['vast_thirdparty_impression'] = $aFields['vast_thirdparty_impression'];

	/*DAC015*/
	$aVastVariables['vast_thirdparty_companion_clicktracking']= $aFields['vast_thirdparty_companion_clicktracking'];
	$aVastVariables['vast_thirdparty_clickcustom']= $aFields['vast_thirdparty_clickcustom'];
	$aVastVariables['vast_thirdparty_clicktracking']= $aFields['vast_thirdparty_clicktracking'];

	$aVastVariables['vast_overlay_expanded_width'] = $aFields['vast_overlay_expanded_width'];
	$aVastVariables['vast_overlay_expanded_height']= $aFields['vast_overlay_expanded_height'];
	$aVastVariables['vast_thirdparty_companion_expandedwidth']= $aFields['vast_thirdparty_companion_expandedwidth'];
	$aVastVariables['vast_thirdparty_companion_expandedheight']= $aFields['vast_thirdparty_companion_expandedheight'];
	$aVastVariables['vast_overlay_expandedminduration']= $aFields['vast_overlay_expandedminduration'];


	 $aVastVariables['vast_video_skip_duration'] = $aFields['vast_video_skip_duration'];
	 $aVastVariables['vast_video_skip_progress_duration'] = $aFields['vast_video_skip_progress_duration'];

	if($aFields['vast_overlay_format']=='wrapper_overlay')
	{
	$aVastVariables['vast_overlay_wrapper'] = $aFields['vast_overlay_wrapper'];
        $aVastVariables['vast_overlay_version'] = $aFields['vast_overlay_version'];
	}
	else
	{
	$aVastVariables['vast_wrapper_url'] = $aFields['vast_wrapper_url'];
        $aVastVariables['vast_version'] = $aFields['vast_version'];
	}
	/*DAC015*/

        // We serialise all the data into an array which is part of the ox_banners table.
        // This is used by the deliveryEngine for serving ads and is faster then all joins
        // plus it gives us automatic caching
        $aVariables['parameters'] = serialize($aVastVariables);

        // attach the parameters to the nomal array to be stored as per normal DataObject technique
        $aVariables = array_merge($aVariables, $aVastVariables);
        return true;
    }

    /**
     * This method is executed AFTER the core banners table is written to
     *
     * @param boolean $insert
     * @param integer $bannerid
     * @param array $aFields
     * @return boolean
     */
    function processForm($insert, $bannerid, $aFields)
    {
        $doBanners = OA_Dal::factoryDO('banner_vast_element');
        $rowId = $aFields['banner_vast_element_id'];
        $doBanners->vast_element_type               = $aFields['vast_element_type'];
        $doBanners->vast_video_id                   = $aFields['vast_video_id'];
        $doBanners->vast_video_duration             = $aFields['vast_video_duration'];
        $doBanners->vast_video_delivery             = $aFields['vast_video_delivery'];
        $doBanners->vast_video_type                 = $aFields['vast_video_type'];
        $doBanners->vast_video_bitrate              = $aFields['vast_video_bitrate'];
        $doBanners->vast_video_height               = $aFields['vast_video_height'];
        $doBanners->vast_video_width                = $aFields['vast_video_width'];
        $doBanners->vast_video_outgoing_filename    = $aFields['vast_video_outgoing_filename'];
        $doBanners->vast_video_clickthrough_url     = $aFields['vast_video_clickthrough_url'];
        $doBanners->vast_overlay_height             = $aFields['vast_overlay_height'];
        $doBanners->vast_overlay_width              = $aFields['vast_overlay_width'];
        $doBanners->vast_overlay_action             = $aFields['vast_overlay_action'];
        $doBanners->vast_overlay_format             = $aFields['vast_overlay_format'];
        $doBanners->vast_overlay_text_title         = $aFields['vast_overlay_text_title'];
        $doBanners->vast_overlay_text_description   = $aFields['vast_overlay_text_description'];
        $doBanners->vast_overlay_text_call          = $aFields['vast_overlay_text_call'];
        $doBanners->vast_companion_banner_id        = $aFields['vast_companion_banner_id'];
        $doBanners->vast_creative_type              = $aFields['vast_creative_type'];
        $doBanners->vast_thirdparty_impression      = $aFields['vast_thirdparty_impression'];	
	/*DAC015*/
         $doBanners->vast_video_skip_duration = $aFields['vast_video_skip_duration'];
	 $doBanners->vast_video_skip_progress_duration = $aFields['vast_video_skip_progress_duration'];
	 $doBanners->vast_thirdparty_companion_clicktracking= $aFields['vast_thirdparty_companion_clicktracking'];
	 $doBanners->vast_thirdparty_clickcustom= $aFields['vast_thirdparty_clickcustom'];
	 $doBanners->vast_thirdparty_clicktracking= $aFields['vast_thirdparty_clicktracking'];

	 $doBanners->vast_overlay_expanded_width = $aFields['vast_overlay_expanded_width'];
	 $doBanners->vast_overlay_expanded_height= $aFields['vast_overlay_expanded_height'];
	 $doBanners->vast_thirdparty_companion_expandedwidth= $aFields['vast_thirdparty_companion_expandedwidth'];
	 $doBanners->vast_thirdparty_companion_expandedheight= $aFields['vast_thirdparty_companion_expandedheight'];
	 $doBanners->vast_overlay_expandedminduration= $aFields['vast_overlay_expandedminduration'];


	if($aFields['vast_overlay_format']=='wrapper_overlay')
	{
	$doBanners->vast_overlay_wrapper= $aFields['vast_overlay_wrapper'];
        $doBanners->vast_overlay_version= $aFields['vast_overlay_version'];
	}
	else
	{
	$doBanners->vast_wrapper_url= $aFields['vast_wrapper_url'];
        $doBanners->vast_version= $aFields['vast_version'];
	}
	/*DAC015*/



        if ( !$insert && ($rowId == 'banner_vast_element_id') ){
            // If the mode was update, but we dont have a valid pk value for $rowId
            // it probably because the user removed the plugin, cleaned out the table
            // and then reinstalled  - we therefore need to do an insert NOT an update
            $insert = true;
        }
	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];	
        if ($insert)
        {
            $doBanners->banner_vast_element_id = $bannerid;
            $doBanners->banner_id            = $bannerid;
            $rowId=$doBanners->insert();
		
		/*DAC015*/
		if(!empty($doBanners->vast_video_skip_duration))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_video_skip_duration='".$doBanners->vast_video_skip_duration."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_video_skip_progress_duration))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_video_skip_progress_duration='".$doBanners->vast_video_skip_progress_duration."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_wrapper_url))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_wrapper_url='".$doBanners->vast_wrapper_url."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_version))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_version='".$doBanners->vast_version."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_thirdparty_clicktracking))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_thirdparty_clicktracking='".$doBanners->vast_thirdparty_clicktracking."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_thirdparty_clickcustom))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_thirdparty_clickcustom='".$doBanners->vast_thirdparty_clickcustom."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_thirdparty_companion_clicktracking))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_thirdparty_companion_clicktracking='".$doBanners->vast_thirdparty_companion_clicktracking."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_thirdparty_companion_expandedheight))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_thirdparty_companion_expandedheight='".$doBanners->vast_thirdparty_companion_expandedheight."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_thirdparty_companion_expandedwidth))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_thirdparty_companion_expandedwidth='".$doBanners->vast_thirdparty_companion_expandedwidth."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_overlay_expanded_height))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_overlay_expanded_height='".$doBanners->vast_overlay_expanded_height."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_overlay_expanded_width))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_overlay_expanded_width='".$doBanners->vast_overlay_expanded_width."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_overlay_expandedminduration))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_overlay_expandedminduration='".$doBanners->vast_overlay_expandedminduration."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_overlay_version))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_overlay_version='".$doBanners->vast_overlay_version."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_overlay_wrapper))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_overlay_wrapper='".$doBanners->vast_overlay_wrapper."' WHERE banner_vast_element_id='$rowId'");
		}
/*DAC015*/




	    	return 1;
        }
        else
        {
			/*DAC015*/
		if(!empty($doBanners->vast_video_skip_duration))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_video_skip_duration='".$doBanners->vast_video_skip_duration."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_video_skip_progress_duration))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_video_skip_progress_duration='".$doBanners->vast_video_skip_progress_duration."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_wrapper_url))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_wrapper_url='".$doBanners->vast_wrapper_url."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_version))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_version='".$doBanners->vast_version."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_thirdparty_clicktracking))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_thirdparty_clicktracking='".$doBanners->vast_thirdparty_clicktracking."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_thirdparty_clickcustom))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_thirdparty_clickcustom='".$doBanners->vast_thirdparty_clickcustom."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_thirdparty_companion_clicktracking))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_thirdparty_companion_clicktracking='".$doBanners->vast_thirdparty_companion_clicktracking."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_thirdparty_companion_expandedheight))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_thirdparty_companion_expandedheight='".$doBanners->vast_thirdparty_companion_expandedheight."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_thirdparty_companion_expandedwidth))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_thirdparty_companion_expandedwidth='".$doBanners->vast_thirdparty_companion_expandedwidth."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_overlay_expanded_height))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_overlay_expanded_height='".$doBanners->vast_overlay_expanded_height."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_overlay_expanded_width))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_overlay_expanded_width='".$doBanners->vast_overlay_expanded_width."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_overlay_expandedminduration))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_overlay_expandedminduration='".$doBanners->vast_overlay_expandedminduration."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_overlay_version))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_overlay_version='".$doBanners->vast_overlay_version."' WHERE banner_vast_element_id='$rowId'");
		}
		if(!empty($doBanners->vast_overlay_wrapper))
		{
		OA_Dal_Delivery_query("UPDATE {$table_prefix}banner_vast_element SET vast_overlay_wrapper='".$doBanners->vast_overlay_wrapper."' WHERE banner_vast_element_id='$rowId'");
		}
/*DAC015*/

            $doBanners->whereAdd('banner_vast_element_id='. (int)$rowId, 'AND');
            return $doBanners->update(DB_DATAOBJECT_WHEREADD_ONLY);
        }
    }


    function getExtendedBannerInfo($banner)
    {
        $actualBannerId = $banner['bannerid'];
        $vastElements = array();
        if ( $actualBannerId ){
            $vastElements = $this->fetchBannersJoined($actualBannerId);
            // For now assume 1:1 relationship
            if ( isset($vastElements[0]) ){
		/*DAC015*/
		if($vastElements[0]['vast_overlay_expanded_width']==0){$vastElements[0]['vast_overlay_expanded_width']='';}
		if($vastElements[0]['vast_overlay_expanded_height']==0){$vastElements[0]['vast_overlay_expanded_height']='';}
		if($vastElements[0]['vast_thirdparty_companion_expandedwidth']==0){$vastElements[0]['vast_thirdparty_companion_expandedwidth']='';}
		if($vastElements[0]['vast_thirdparty_companion_expandedheight']==0){$vastElements[0]['vast_thirdparty_companion_expandedheight']='';}
		/*DAC015*/
                $elementRow = $vastElements[0];
                $banner = array_merge( $banner, $elementRow );
            }

            $aDeliveryFieldsNotUsed = array();
            parseVideoUrl( $banner, $aDeliveryFieldsNotUsed, $banner );
        }
        return $banner;
    }

    function fetchBannersJoined($bannerId, $fetchmode=MDB2_FETCHMODE_ORDERED)
    {
        $aConf  = $GLOBALS['_MAX']['CONF']['table'];
        $oDbh   = OA_DB::singleton();
        $tblB   = $oDbh->quoteIdentifier($aConf['prefix'].'banners',true);
        $tblD   = $oDbh->quoteIdentifier($aConf['prefix'].'banner_vast_element');
        $query  = "SELECT d.* FROM ".$tblB." b"
                     ." LEFT JOIN ".$tblD." d ON b.bannerid = d.banner_id"
                     ." WHERE b.ext_bannertype = '".$this->getComponentIdentifier()."'"
                     ." AND b.bannerid = ".(int)$bannerId;
        $joinedResult = $oDbh->queryAll($query, null, MDB2_FETCHMODE_ASSOC, false, false, true );
        return $joinedResult;
    }

    /**
     * Custom validation method
     * This is executed AFTER form submit
     * Main validation is handled by adding rules to the form in buildForm()
     * which are processed prior to this method being called
     *
     * @param object $form
     * @return boolean
     */
    function validateForm(&$form)
    {
	/*DAC015*/
        if($form->isSubmitted()) {
            $errors = array();
	   if($form->getSubmitValue('vast_video_delivery')!='vast')
	   {
            foreach($this->requiredElement as $requiredElement) {
                $fieldName = $requiredElement[0];
                $fieldNameWhenRequired = $requiredElement[1];
                $fieldValueWhenRequired = $requiredElement[2];
                $fieldValueWhenRequiredSubmittedValue = $form->getSubmitValue($fieldNameWhenRequired);
                if($fieldValueWhenRequiredSubmittedValue == $fieldValueWhenRequired) {
                    $submittedValue = $form->getSubmitValue($fieldName);
                    if(empty($submittedValue)) {
                        $errors[] = $this->getFieldLabel($fieldName);
                    }
                }
            }

            if(count($errors) == 0) {
                if ($form->getSubmitValue('vast_video_type') != 'video/webm' || $form->getSubmitValue('vast_video_delivery') == 'progressive') {
                    $form->removeElement('video_form_error');
                    return true;
                } else {
                    $errorString = 'WEBM video type is not compatible with streaming delivery';
                }
            } else {
                $errorString = 'Please provide values for all required fields: <ul><li>';
                $errorString .= implode('</li><li>', $errors);
                $errorString .= '</li></ul>';
            }

            $form->getElement('video_form_error')->setText(VideoAdsHelper::getErrorMessage($errorString));
            return false;

	}
	else
	{
		if (!($form->getSubmitValue('vast_wrapper_url')!='' && $form->getSubmitValue('vast_version')!=''))
		{
			  $errorString = 'Please provide values for all required field of third party vast tag';

		}

	}

        }
	/*DAC015*/
        return true;
    }

    function getPossibleCompanions($aBannerRow)
    {
        $aParams = array( 'placement_id' => $aBannerRow['campaignid'] );
        $possibleCompanions = Admin_DA::_getEntities('ad', $aParams, true);
        $selectableCompanions = array( 0 => 'none' );
        foreach( $possibleCompanions as $currentCompanion ){
            // Only allow linking to banners that are not of type "vast"
            if ( strpos( $currentCompanion['ext_bannertype'], 'vast' ) === false ){
                $strNameToDisplay = $currentCompanion['name'] . " (" . $currentCompanion['width'] . "x" . $currentCompanion['height'] . " )";
                $selectableCompanions[$currentCompanion['ad_id'] ] = $strNameToDisplay;
            }
        }
        return $selectableCompanions;
    }


    function getAllFieldsLabels()
    {
        $labels = array(
            'vast_video_type' => "Video type",
            'vast_video_duration' => "Video duration in seconds",
            'vast_net_connection_url' => "RTMP server URL",
            'vast_video_filename' => 'Video filename',
            'vast_video_filename_http' => 'Video URL', // not submitted in the form itself, but string is displayed to
            'vast_video_delivery' => 'Video delivery method',
        );
        return $labels;
    }

    function getFieldLabel($fieldName)
    {
        $labels = $this->getAllFieldsLabels();
        return $labels[$fieldName];
    }

    /**
     * Set a given form field "required". We can't use the required feature of quickform,
     * because this form is JS based, and depending on the selection, fields might not be required.
     *
     *  This function is used to define which fields are required ($element)
     *  and when they are required: when $fieldNameWhenRequired == $fieldValueWhenRequired
     *
     * @param $form
     * @param $element array of info that is being passed to QuickForm->addElement
     * @param $fieldNameWhenRequired string
     * @param $fieldValueWhenRequired string
     */
    function addFormRequiredElement(&$form, $element, $fieldNameWhenRequired = null, $fieldValueWhenRequired = null)
    {
        // add the red star in the name
        $element[2] = $this->getLabelWithRequiredStar($element[2]);

        // we do not add the element as "required" in the form, as we need to test which fields
        // are required depending on overlay types, video delivery types, etc.
        call_user_func_array(array($form, 'addElement'), $element);

        $fieldName = $element[1];
        $this->setElementIsRequired($fieldName, $fieldNameWhenRequired, $fieldValueWhenRequired);
    }

    function getLabelWithRequiredStar($label)
    {
        return $label . ' <font color="red">*</font>';
    }
    function setElementIsRequired($fieldName, $fieldNameWhenRequired, $fieldValueWhenRequired)
    {
        $this->requiredElement[] = array( $fieldName , $fieldNameWhenRequired, $fieldValueWhenRequired);
    }

    function addVastParametersToForm(&$form, &$bannerRow, $isNewBanner)
    {
        $form->addElement('hidden', 'banner_vast_element_id', "banner_vast_element_id");
        $form->addElement('hidden', 'vast_element_type', "singlerow");

        $this->addVastVideoUrlFields($form, $bannerRow, $isNewBanner);

        $sampleUrls = array(
            'RTMP - FLV' => array(
            	"rtmp://cp81850.edgefcs.net/ondemand/",
                "openx-ad",
                'FLV',
                '8',
            ),

            'RTMP - MP4' => array(
        		"rtmp://cp81850.edgefcs.net/ondemand/",
        		"openx-ad.mp4",
                'MP4',
                '10',
            ),

            'HTTP - FLV' => array(
            	"http://videoads.openx.org.edgesuite.net/openxvideos/openx-ad.flv",
                'FLV',
            	'8',
            ),

            'HTTP - MP4' => array(
            	"http://videoads.openx.org.edgesuite.net/openxvideos/openx-ad.mp4",
                'MP4',
                '10'
            ),

            'HTTP - WEBM' => array(
            	"http://video.webmfiles.org/big-buck-bunny_trailer.webm",
                'WEBM',
                '32'
            ),

        );

        $sampleAdsString = 'You can try using any of the following sample ads<br/><br/>';
        foreach($sampleUrls as $what => $urls) {
            $sampleAdsString .= "<b>$what sample ads</b><ul style='margin-top:5px'>";
            if(count($urls) == 3) {
               $sampleAdsString .= '<li>'.$this->getFieldLabel('vast_video_filename_http') . ': '. $urls[0];
               $sampleAdsString .= '<li>'.$this->getFieldLabel('vast_video_type') . ': '. $urls[1];
               $sampleAdsString .= '<li>'.$this->getFieldLabel('vast_video_duration') . ': '. $urls[2];
            } else {
               $sampleAdsString .= '<li>'.$this->getFieldLabel('vast_net_connection_url') . ': '. $urls[0];
               $sampleAdsString .= '<li>'.$this->getFieldLabel('vast_video_filename') . ': '. $urls[1];
               $sampleAdsString .= '<li>'.$this->getFieldLabel('vast_video_type') . ': '. $urls[2];
               $sampleAdsString .= '<li>'.$this->getFieldLabel('vast_video_duration') . ': '. $urls[3];
            }
            $sampleAdsString .= "</ul>";
        }
        $sampleAdsString .= '';
        $form->addElement('html', 'video_status_info_rtmp_mp4', VideoAdsHelper::getWarningMessage($sampleAdsString) );

        $advancedUser = false;
        if ( $advancedUser ){
            // Bitrate of encoded video in Kbps
            $form->addElement('text', 'vast_video_bitrate', "vast_video_bitrate");
            // Pixel dimensions of video
            $form->addElement('text', 'vast_video_width', "vast_video_width");
            $form->addElement('text', 'vast_video_height', "vast_video_height");
        }
        else {
            // hide these for now - the player ignores them anyway - atm
            $form->addElement('hidden', 'vast_video_bitrate', "vast_video_bitrate");
            $form->addElement('hidden', 'vast_video_width', "vast_video_width");
            $form->addElement('hidden', 'vast_video_height', "vast_video_height");
        }

        if ( $isNewBanner ){
            $bannerRow['vast_video_bitrate'] = '400';
            $bannerRow['vast_video_width'] = '640';
            $bannerRow['vast_video_height'] = '480';
        }
    }

    function addThirdPartyImpressionTracking( &$form )
    {
        $form->addElement('header', 'thirdpartyimp_title', 'Third party impression tracking');
        $form->addElement('html', 'thirdpartyimp_help', '
        	When a video ad is displayed, OpenX will record the ad impression.
        	You can also specify a URL to a third party 1x1 transparent pixel.
        	The URL can contain any of the supported <a href="http://documentation.revive-adserver.com/display/DOCS/Magic+Macros" target="_blank">magic macros</a>.
        					');

        $form->addElement(  'text',
        					'vast_thirdparty_impression',
        					'Impression tracking beacon URL <br>(incl. http://)');
    }

	/*DAC015*/

    function addThirdPartyClickTracking( &$form )
    {
        $form->addElement('header', 'thirdpartyimp_title', 'Third party Click tracking');
        $form->addElement('html', 'thirdpartyclick_help', 'Contains a URI to a location or file that the video player should request
when the user clicks within the video frame while the Linear ad is played;the server can also use requests to this URI for tracking the “clickthrough” metric');

            $form->addElement(  'text',
        					'vast_thirdparty_clicktracking',
        					'Third Party Click tracking URL <br>(incl. http://)');
	    $form->addElement(  'text',
        					'vast_thirdparty_clickcustom',
        					'Third Party Click tracking Custom URL <br>(incl. http://)');
    }

    function addoverlayadvanced( &$form )
    {
        $form->addElement('header', 'advanced_feature', 'Overlay Advanced Settings');
	 $form->addElement('text','vast_overlay_expanded_width','Expanded Width');//DAC015
         $form->addElement('text','vast_overlay_expanded_height','Expanded Height');//DAC015
	 $form->addElement('text','vast_overlay_expandedminduration','Min Suggested Duration');//DAC015
    }



	/*DAC015*/
    function addVastCompanionsToForm( &$form, $selectableCompanions)
    {
        $form->addElement('header', 'companion_status', "Companion banner");
        $doCampaigns = OA_Dal::factoryDO('campaigns');
        $doCampaigns->campaignid = $GLOBALS['campaignid'];
        $doCampaigns->find();
        $doCampaigns->fetch();
        if(OX_Util_Utils::getCampaignType($doCampaigns->priority) == OX_CAMPAIGN_TYPE_CONTRACT_NORMAL)
        {
            $form->addElement('html', 'companion_help_contract',
                            '<br/><b>Note:</b> Revive Adserver currently doesn\'t support the display of a companion banner for "Contract" campaigns.
                             <br/>If you wish to display a companion banner, please select a "Remnant" or "Override" campaign.');

            return;
        }
        $helpLinkPlayer = VideoAdsHelper::getHelpLinkVideoPlayerConfig();

        $form->addElement('html', 'companion_help', 'To associate a companion banner to this video ad, select a banner from the companion banner dropdown. This banner will appear for the duration of the video ad. <br/>
        					You will need to specify where this companion banner appears on the page while setting up your video ad in the video player plugin configuration. <a href="'.$helpLinkPlayer.'" target="_blank">Learn more</a>
        					');

        $form->addElement('select','vast_companion_banner_id','Companion banner', $selectableCompanions);

	 $form->addElement(  'text',
        					'vast_thirdparty_companion_clicktracking',
        					'Third Party Click tracking URL <br>(incl. http://)');//DAC015
	 $form->addElement(  'text',
        					'vast_thirdparty_companion_expandedwidth',
        					'Expanded Width)');//DAC015
	 $form->addElement(  'text',
        					'vast_thirdparty_companion_expandedheight',
        					'Expanded Height)');//DAC015
	
    }


    function addVastHardcodedDimensionsToForm(&$form, &$bannerRow, $dimension)
    {
        $bannerRow['width'] = $dimension;
        $bannerRow['height'] = $dimension;
        $form->addElement('hidden', 'width' );
        $form->addElement('hidden', 'height');
    }

    function addIntroductionInlineHelp(&$form)
    {
        $helpString = $this->getHelpAdTypeDescription();
        $crossdomainUrl = MAX_commonConstructDeliveryUrl('crossdomain.xml');
        // because flash apps look at http://domain/crossdomain.xml, we need to construct this URL and keep only the hostname
        $crossdomainUrl = parse_url($crossdomainUrl);
        $crossdomainUrl = $crossdomainUrl['scheme'] . '://' . $crossdomainUrl['host'] . '/crossdomain.xml';

        $helpString .= "<br/><br/>To setup your ".$this->getBannerShortName().", you will need to:
        <ul style='list-style-type:decimal;padding-left:20px;padding-top:5px'>
        <li>Enter the information about your Ad in the form below.</li>
        <li>Link this ".$this->getBannerShortName()." to the desired zone. The zone must be of the type \"".$this->getZoneToLinkShortName()."\". <a href='".VideoAdsHelper::getHelpLinkOpenXPlugin() ."' target='_blank'>Learn more</a></li>
        <li>Include the zone in the Ad Schedule of the video player plugin configuration in your webpage. <a href='". VideoAdsHelper::getHelpLinkVideoPlayerConfig() ."' target='_blank'>Learn more</a></li>
        <li>Make sure that the flash player is allowed to request ads on this adserver. The <a href='$crossdomainUrl' target='_blank'>crossdomain.xml on your adserver</a> should look similar to the <a href='".VideoAdsHelper::getLinkCrossdomainExample()."' target='_blank'>recommended crossdomain.xml</a></li>
    	</ul>";
        $form->addElement('html', 'video_status_info1', '<span style="font-size:100%;">'.$helpString.'</span>' );
    }

    function addVastVideoUrlFields(&$form, &$bannerRow, $isNewBanner)
    {
        $vastVideoDelivery = $form->getSubmitValue('vast_video_delivery');
        if(empty($vastVideoDelivery)
            && !empty($bannerRow['vast_video_delivery'])) {
            $vastVideoDelivery = $bannerRow['vast_video_delivery'];
        }

        if ( $vastVideoDelivery == 'progressive' ) {
            $urlFormatMode  = VAST_VIDEO_URL_PROGRESSIVE_FORMAT;
            $videoUrlFormatOptionToRunOnPageLoad = "phpAds_formHttpProgressiveVideoUrlMode();";
        } else if($vastVideoDelivery == 'streaming'){
            $urlFormatMode  = VAST_VIDEO_URL_STREAMING_FORMAT;
            $videoUrlFormatOptionToRunOnPageLoad = "phpAds_formRtmpStreamingVideoUrlMode();";
        }
	else
	{
	    $urlFormatMode  = VAST_VIDEO_URL_VAST_FORMAT;
            $videoUrlFormatOptionToRunOnPageLoad = "phpAds_formVastVideoUrlMode();";
        }

        $httpVideoUrlString = $this->getLabelWithRequiredStar($this->getFieldLabel('vast_video_filename_http'));
        $videoFilenameString = $this->getLabelWithRequiredStar($this->getFieldLabel('vast_video_filename'));

        $videoUrlFomatOptionJs = <<<VIDEO_FORMAT_OPTION_JS
            <script type="text/javascript">
            function phpAds_formRtmpStreamingVideoUrlMode()
            {
                $("#vast_video_delivery").attr('value', 'streaming');
                $("label[for=vast_net_connection_url]").show();
                $("#vast_net_connection_url").show();
                $("label[for=vast_video_filename]").html('${videoFilenameString}');

			$("label[for=vast_video_filename]").show();
                	$("#vast_video_filename").show();
			$("label[for=vast_video_type]").show();
                	$("#vast_video_type").show();
			$("label[for=vast_video_duration]").show();
                	$("#vast_video_duration").show();

			$("label[for=vast_wrapper_url]").hide();
                	$("#vast_wrapper_url").hide(); 

			$("label[for=vast_version]").hide();
                	$("#vast_version").hide(); 

            }
            function phpAds_formHttpProgressiveVideoUrlMode()
            {
                $("#vast_net_connection_url").attr('value', '');
                $("#vast_video_delivery").attr('value', 'progressive');
                $("label[for=vast_net_connection_url]").hide();
                $("#vast_net_connection_url").hide();
                $("label[for=vast_video_filename]").html('${httpVideoUrlString}');


			$("label[for=vast_video_filename]").show();
                	$("#vast_video_filename").show();
			$("label[for=vast_video_type]").show();
                	$("#vast_video_type").show();
			$("label[for=vast_video_duration]").show();
                	$("#vast_video_duration").show();
	

			$("label[for=vast_wrapper_url]").hide();
                	$("#vast_wrapper_url").hide(); 

			$("label[for=vast_version]").hide();
                	$("#vast_version").hide(); 


            }
	    function phpAds_formVastVideoUrlMode()
	    {

		$("label[for=vast_net_connection_url]").hide();
                $("#vast_net_connection_url").hide();
		$("label[for=vast_video_filename]").hide();
                $("#vast_video_filename").hide();
		$("label[for=vast_video_duration]").hide();
                $("#vast_video_duration").hide();
		$("label[for=vast_video_type]").hide();
                $("#vast_video_type").hide(); 

			$("label[for=vast_wrapper_url]").show();
                	$("#vast_wrapper_url").show(); 

			$("label[for=vast_version]").show();
                	$("#vast_version").show(); 


	    }
            $(document).ready( function(){
                ${videoUrlFormatOptionToRunOnPageLoad};
            });
            </script>
VIDEO_FORMAT_OPTION_JS;

        $videoUrlFormats[] = $form->createElement(
        										'radio', 'vast_video_delivery', '',
                                                'streaming (RTMP)',
                                                VAST_VIDEO_URL_STREAMING_FORMAT,
                                                array('id' => 'video-url-format-streaming', 'onClick' => 'phpAds_formRtmpStreamingVideoUrlMode();' ));

        $videoUrlFormats[] = $form->createElement(
        								'radio', 'vast_video_delivery', '',
                                        'progressive (HTTP)',
                                        VAST_VIDEO_URL_PROGRESSIVE_FORMAT,
                                        array('id' => 'video-url-format-progressive', 'onClick' => 'phpAds_formHttpProgressiveVideoUrlMode();' ));
        

	  $videoUrlFormats[] = $form->createElement('radio', 'vast_video_delivery', '',
                                        'Third party Vast Tag',
                                        VAST_VIDEO_URL_VAST_FORMAT,
                                        array('id' => 'video-url-format-vast', 'onClick' => 'phpAds_formVastVideoUrlMode();' ));
        


	$this->setElementIsRequired('vast_video_delivery',  'vast_overlay_action', VAST_OVERLAY_CLICK_TO_VIDEO);
        $form->addGroup($videoUrlFormats, 'VideoFormatAction', $this->getLabelWithRequiredStar($this->getFieldLabel('vast_video_delivery')), "<br/>");
        $this->addFormRequiredElement(
                                $form,
                                array('text', 'vast_net_connection_url', $this->getFieldLabel('vast_net_connection_url')),
                                'vast_video_delivery',
                                VAST_VIDEO_URL_STREAMING_FORMAT);
        $this->addFormRequiredElement(
                                $form,
                                array('text', 'vast_video_filename', $this->getFieldLabel('vast_video_filename')),
                                'vast_overlay_action',
                                VAST_OVERLAY_CLICK_TO_VIDEO);
        $form->addElement('html', 'jsForVideoFormat', $videoUrlFomatOptionJs );

        $vastVideoType = getVastVideoTypes();
        // adding empty SELECT entry to ensure users make a decision and select the right Video type
        $vastVideoType = array_merge( array( '' => ''), $vastVideoType);

        $this->addFormRequiredElement(
                                $form,
                                array('select', 'vast_video_type', $this->getFieldLabel('vast_video_type'), $vastVideoType),
                                'vast_overlay_action',
                                VAST_OVERLAY_CLICK_TO_VIDEO);
        $this->addFormRequiredElement(
                                $form,
                                array('text', 'vast_video_duration', $this->getFieldLabel('vast_video_duration')),
                                'vast_overlay_action',
                                VAST_OVERLAY_CLICK_TO_VIDEO);
        $form->addElement('text', 'vast_video_clickthrough_url', "Destination URL (incl. http://) <br />when user clicks on the video");
	/*DAC015*/
	$this->addFormRequiredElement(
                                $form,
                                array('text', 'vast_wrapper_url','Third Party Vast Tag'),
                                'vast_video_delivery',
                                VAST_VIDEO_URL_VAST_FORMAT);


	$getvastversion=getvastversion();

	$this->addFormRequiredElement(
                                $form,
                                array('select', 'vast_version','Vast Version', $getvastversion),
                                VAST_VERSION,array('id' => 'vast_version', 'onChange' => 'phpAds_skip();' ));

	$form->addElement('header', 'VAST 3.0 Speacial Features', "VAST 3.0 Speacial Features");

	$form->addElement('text', 'vast_video_skip_duration','Skippable Inline Offset[Note:Format should be HH:MM:SS or HH:MM:SS.mmm or a percentage  n%]','vast_overlay_action');

	$form->addElement('text', 'vast_video_skip_progress_duration','Skippable Inline Progress Offset[Note:Format should be(HH:MM:SS or HH:MM:SS.mmm) or percentage n%]','vast_overlay_action');
	/*DAC015*/
    }
}

